//
//  MCHUDCanvas.h
//  HudTest
//
//  Created by Ali Lalani on 10/15/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCHUDCanvas : NSView {	
	id model;
	NSButton *__addButton;

	int numberOfColumns;
	
	BOOL handlesScrolling;

	NSMutableArray *columns;

	NSRect __addButtonRect;
	BOOL __mouseDownInPlusButton;

	NSString *applicableEntityName;
	NSString *identifier;

	id document;
}
- (IBAction)addButtonDidAct:(id)sender;

- (void)configureWithIdentifier:(NSString *)anIdentifier;
- (float)preferredHeight;
- (void)tile;
- (NSArray *)widgetIdentifiers; // array of identifiers for all widgets currently in the canvas
- (void)addWidgetWithIdentifier:(NSString *)ident;
- (void)removeWidgetWithIdentifier:(NSString *)ident;
- (NSDictionary *)hudConfiguration; // generates a dictionary for configuration from the current state
- (void)saveStateToDefaults;

#pragma mark Accessors
- (id)model;
- (void)setModel:(id)aModel;

- (int)numberOfColumns;
- (void)setNumberOfColumns:(int)aNumberOfColumns;

- (BOOL)handlesScrolling;
- (void)setHandlesScrolling:(BOOL)flag;

- (NSMutableArray *)columns;
- (void)setColumns:(NSMutableArray *)aColumns;

- (NSString *)applicableEntityName;
- (void)setApplicableEntityName:(NSString *)anApplicableEntityName;

- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (id)document;
- (void)setDocument:(id)aDocument;
@end
